// Function to generate the calendar for the current month and year
function generateCalendar(month, year) {
    const calendarElement = document.getElementById('calendar');
    const monthYearElement = document.getElementById('calendar-month');
    const daysInMonth = new Date(year, month + 1, 0).getDate();  // Get the number of days in the month
    const firstDayOfMonth = new Date(year, month, 1).getDay();  // Get the first day of the month (0 = Sunday, 6 = Saturday)

    // Adjust for the week starting on Monday (shift days so Monday is 0)
    const adjustedFirstDay = (firstDayOfMonth === 0) ? 6 : firstDayOfMonth - 1;

    // Pattern for the custom numbers: "1", "1", "2-3", "blank", "blank", "3", "blank", "blank", repeat
    const pattern = ['1', '1', '2-3', '', '', '3', '', ''];
	const weekdays = ['Mon', 'Tue', 'Wed', 'Thr', 'Fri', 'Sat', 'Sun'];

    // Update the month and year display
    monthYearElement.innerText = new Date(year, month).toLocaleString('default', { month: 'long', year: 'numeric' });

    // Clear the previous calendar content
    calendarElement.innerHTML = '';

    // Date representing November 30th, 2024
    const targetDate = new Date(2024, 10, 30);  // November 30th, 2024

    // Create empty spaces before the first day of the month (for the previous month's overflow days)
	weekdays.forEach(weekday => {
        const weekdayCell = document.createElement('div');
		weekdayCell.innerText = weekday;
        weekdayCell.classList.add('day', 'calendar-header-day');
        calendarElement.appendChild(weekdayCell);
	});

    // Create empty spaces before the first day of the month (for the previous month's overflow days)
    for (let i = 0; i < adjustedFirstDay; i++) {
        const emptyCell = document.createElement('div');
        emptyCell.classList.add('day', 'blank', weekdays[i % weekdays.length].toLowerCase());
        calendarElement.appendChild(emptyCell);
    }

    // Start the calendar days generation
    let dayCounter = 1;  // Start from the 1st of the month

    // Generate the days of the month and apply the pattern based on the difference
    for (let day = adjustedFirstDay + 1; day <= 42; day++) {
        if (dayCounter > daysInMonth) break;  // Stop once we've passed the number of days in the month

        const dayCell = document.createElement('div');
        dayCell.classList.add('day', weekdays[(day-1) % weekdays.length].toLowerCase());

        // Create and append the actual date
        const dateElement = document.createElement('div');
        dateElement.classList.add('date');
        dateElement.innerText = dayCounter;
        dayCell.appendChild(dateElement);

        // Only calculate pattern for valid days (not empty cells)
        if (dayCounter <= daysInMonth) {
            // Calculate the difference between the current date (iterated day) and November 30th, 2024
            const iteratedDate = new Date(year, month, dayCounter);  // Current iterated day in the month
            const timeDifference = iteratedDate - targetDate;  // Difference in time (milliseconds)
            const dayDifference = Math.ceil(timeDifference / (1000 * 60 * 60 * 24));  // Convert to days

            // Calculate the pattern index using the absolute day difference and modulo
            const patternIndex = dayDifference % pattern.length;

            // Create and append the custom number for that day based on the pattern
            const customNumbersElement = document.createElement('div');
            customNumbersElement.classList.add('custom-numbers');
            customNumbersElement.innerText = pattern.at(patternIndex);
            dayCell.appendChild(customNumbersElement);
        }

        // Append the day cell to the calendar
        calendarElement.appendChild(dayCell);

        dayCounter++;
    }

    // If the last day of the month doesn't fill the grid, add empty cells to complete the row
    const totalCells = adjustedFirstDay + daysInMonth;
    let cellsRendered = totalCells;
    while (cellsRendered % 7 !== 0) {
        const emptyCell = document.createElement('div');
        emptyCell.classList.add('day', 'blank', weekdays[(cellsRendered) % weekdays.length].toLowerCase());
        calendarElement.appendChild(emptyCell);
        cellsRendered++;
    }
}

// Function to change the month when clicking the arrow buttons
function changeMonth(direction) {
    currentDate.setMonth(currentDate.getMonth() + direction); // Adjust the month
    generateCalendar(currentDate.getMonth(), currentDate.getFullYear()); // Regenerate the calendar
}

function clampMonth(month) {
	return Math.max(1, Math.min(12, month));
}

// Function to go to a specific month and year based on user input
function goToDate() {
    const monthInput = clampMonth(document.getElementById('month-input').value ?? 1);
    const yearInput = Math.max(document.getElementById('year-input').value ?? 1, 1);
	currentDate.setMonth(monthInput - 1); // Set the month (0-based index)
	currentDate.setFullYear(yearInput);  // Set the year
	generateCalendar(currentDate.getMonth(), currentDate.getFullYear()); // Regenerate the calendar
}

// Initialize the current date to the current month
let currentDate = new Date(); // Set to the current date
generateCalendar(currentDate.getMonth(), currentDate.getFullYear());

// Event listeners for the arrow buttons
document.getElementById('prev-month').addEventListener('click', function() {
    changeMonth(-1);
});
document.getElementById('next-month').addEventListener('click', function() {
    changeMonth(1);
});

document.getElementById('go-to-date').addEventListener('click', goToDate);
