const users = [
    {
        "name": "Goce",
        "targetDate": "2025-05-07",
    },
    {
        "name": "Pavle",
        "targetDate": "2025-05-05",
    },
    {
        "name": "Laste",
        "targetDate": "2025-05-03",
    },
    {
        "name": "Bojan",
        "targetDate": "2025-05-01",
    },
];

let currentDate = new Date();

// Function to generate the calendar for the current month and year
const generateCalendar = (month, year) => {

    const calendarElement = document.getElementById('calendar');
    const monthYearElement = document.getElementById('calendar-month');
    const daysInMonth = new Date(year, month + 1, 0).getDate();
    const firstDayOfMonth = new Date(year, month, 1).getDay();

    // Adjust for the week starting on Monday (shift days so Monday is 0)
    const adjustedFirstDay = (firstDayOfMonth === 0) ? 6 : firstDayOfMonth - 1;

    const pattern = ['1', '1', '2-3', '', '', '3', '', ''];

    monthYearElement.innerText = new Date(year, month).toLocaleString('default', { month: 'long', year: 'numeric' });

    calendarElement.innerHTML = '';

    const weekdays = ['Mon', 'Tue', 'Wed', 'Thr', 'Fri', 'Sat', 'Sun'];
    weekdays.forEach(weekday => {
        const weekdayCell = document.createElement('div');
        weekdayCell.innerText = weekday;
        weekdayCell.classList.add('day', 'calendar-header-day');
        calendarElement.appendChild(weekdayCell);
    });

    // Create empty spaces before the first day of the month (for the previous month's overflow days)
    for (let i = 0; i < adjustedFirstDay; i++) {
        const emptyCell = document.createElement('div');
        emptyCell.classList.add('day', 'blank', weekdays[i % weekdays.length].toLowerCase());
        calendarElement.appendChild(emptyCell);
    }

    let cellsRendered = adjustedFirstDay;
    let dayCounter = 1;

    for (let day = adjustedFirstDay + 1; day <= 42; day++) {
        if (dayCounter > daysInMonth) break;

        const dayCell = document.createElement('div');
        dayCell.classList.add('day', weekdays[(day - 1) % weekdays.length].toLowerCase());

        const dateElement = document.createElement('div');
        dateElement.classList.add('date');
        dateElement.innerText = dayCounter;
        dayCell.appendChild(dateElement);

        const patternContainer = document.createElement('div');
        patternContainer.classList.add('patterns');

        users.forEach(user => {
            const userTargetDate = new Date(user.targetDate);
            const iteratedDate = new Date(year, month, dayCounter);
            const timeDifference = iteratedDate - userTargetDate;
            const dayDifference = Math.ceil(timeDifference / (1000 * 60 * 60 * 24));

            const patternIndex = dayDifference % pattern.length;

            const userPatternElement = document.createElement('div');
            const currentPattern = pattern[patternIndex] || '';
            if (currentPattern !== '') {
                userPatternElement.classList.add('user-pattern', `user-${user.name.toLowerCase()}`);
                userPatternElement.innerText = `${user.name} - ${pattern.at(patternIndex)}`;
                patternContainer.appendChild(userPatternElement);
            }
        });

        dayCell.appendChild(patternContainer);
        calendarElement.appendChild(dayCell);
        cellsRendered++;
        dayCounter++;
    }

    // Ensure 6 rows (42 days) by adding empty cells if needed
    while (cellsRendered < 42) {
        const emptyCell = document.createElement('div');
        emptyCell.classList.add('day', 'blank', weekdays[(cellsRendered) % weekdays.length].toLowerCase());
        calendarElement.appendChild(emptyCell);
        cellsRendered++;
    }
};

const changeMonth = (direction) => {
    currentDate.setMonth(currentDate.getMonth() + direction);
    generateCalendar(currentDate.getMonth(), currentDate.getFullYear());
};

const clampMonth = (month) => Math.max(1, Math.min(12, month));

const goToDate = () => {
    const monthInput = clampMonth(document.getElementById('month-input').value ?? 1);
    const yearInput = Math.max(document.getElementById('year-input').value ?? 1, 1);
    currentDate.setMonth(monthInput - 1);
    currentDate.setFullYear(yearInput);
    generateCalendar(currentDate.getMonth(), currentDate.getFullYear());
};

generateCalendar(currentDate.getMonth(), currentDate.getFullYear());

document.getElementById('prev-month').addEventListener('click', () => changeMonth(-1));
document.getElementById('next-month').addEventListener('click', () => changeMonth(1));
document.getElementById('go-to-date').addEventListener('click', goToDate);
